/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Step;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.AspectUtils;
import io.qameta.allure.util.NamingUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.Objects;
import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class StepsAspects {
    private static AllureLifecycle lifecycle;

    @Around(value="@annotation(io.qameta.allure.Step) && execution(* *(..))")
    public Object step(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Step step = methodSignature.getMethod().getAnnotation(Step.class);
        String name = step.value().isEmpty() ? methodSignature.getName() : NamingUtils.processNameTemplate(step.value(), AspectUtils.getParametersMap(methodSignature, joinPoint.getArgs()));
        String uuid = UUID.randomUUID().toString();
        StepResult result = new StepResult().withName(name).withParameters(AspectUtils.getParameters(methodSignature, joinPoint.getArgs()));
        StepsAspects.getLifecycle().startStep(uuid, result);
        try {
            Object proceed = joinPoint.proceed();
            StepsAspects.getLifecycle().updateStep(uuid, s -> s.withStatus(Status.PASSED));
            Object object = proceed;
            return object;
        }
        catch (Throwable e) {
            StepsAspects.getLifecycle().updateStep(uuid, s -> s.withStatus(ResultsUtils.getStatus(e).orElse(Status.BROKEN)).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails(e).orElse(null)));
            throw e;
        }
        finally {
            StepsAspects.getLifecycle().stopStep(uuid);
        }
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }
}

