/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import com.google.common.io.Resources;
import io.qameta.allure.AllureResultsWriteException;
import io.qameta.allure.Description;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Owner;
import io.qameta.allure.Severity;
import io.qameta.allure.SeverityLevel;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.util.PropertiesUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResultsUtils {
    public static final String ALLURE_HOST_NAME_SYSPROP = "allure.hostName";
    public static final String ALLURE_HOST_NAME_ENV = "ALLURE_HOST_NAME";
    public static final String ALLURE_THREAD_NAME_SYSPROP = "allure.threadName";
    public static final String ALLURE_THREAD_NAME_ENV = "ALLURE_THREAD_NAME";
    public static final String ISSUE_LINK_TYPE = "issue";
    public static final String TMS_LINK_TYPE = "tms";
    public static final String EPIC_LABEL_NAME = "epic";
    public static final String FEATURE_LABEL_NAME = "feature";
    public static final String STORY_LABEL_NAME = "story";
    public static final String SEVERITY_LABEL_NAME = "severity";
    public static final String TAG_LABEL_NAME = "tag";
    public static final String OWNER_LABEL_NAME = "owner";
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultsUtils.class);
    private static final String ALLURE_DESCRIPTIONS_PACKAGE = "allureDescriptions/";
    private static String cachedHost;

    private ResultsUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static Label createEpicLabel(String epic) {
        return new Label().withName(EPIC_LABEL_NAME).withValue(epic);
    }

    public static Label createFeatureLabel(String feature) {
        return new Label().withName(FEATURE_LABEL_NAME).withValue(feature);
    }

    public static Label createStoryLabel(String story) {
        return new Label().withName(STORY_LABEL_NAME).withValue(story);
    }

    public static Label createTagLabel(String tag) {
        return new Label().withName(TAG_LABEL_NAME).withValue(tag);
    }

    public static Label createOwnerLabel(String owner) {
        return new Label().withName(OWNER_LABEL_NAME).withValue(owner);
    }

    public static Label createSeverityLabel(SeverityLevel severity) {
        return ResultsUtils.createSeverityLabel(severity.value());
    }

    public static Label createSeverityLabel(String severity) {
        return new Label().withName(SEVERITY_LABEL_NAME).withValue(severity);
    }

    public static Label createLabel(Owner owner) {
        return ResultsUtils.createOwnerLabel(owner.value());
    }

    public static Label createLabel(Severity severity) {
        return ResultsUtils.createSeverityLabel(severity.value());
    }

    public static Label createLabel(Story story) {
        return ResultsUtils.createStoryLabel(story.value());
    }

    public static Label createLabel(Feature feature) {
        return ResultsUtils.createFeatureLabel(feature.value());
    }

    public static Label createLabel(Epic epic) {
        return ResultsUtils.createEpicLabel(epic.value());
    }

    public static io.qameta.allure.model.Link createIssueLink(String value) {
        return ResultsUtils.createLink(value, null, null, ISSUE_LINK_TYPE);
    }

    public static io.qameta.allure.model.Link createTmsLink(String value) {
        return ResultsUtils.createLink(value, null, null, TMS_LINK_TYPE);
    }

    public static io.qameta.allure.model.Link createLink(Link link) {
        return ResultsUtils.createLink(link.value(), link.name(), link.url(), link.type());
    }

    public static io.qameta.allure.model.Link createLink(Issue link) {
        return ResultsUtils.createIssueLink(link.value());
    }

    public static io.qameta.allure.model.Link createLink(TmsLink link) {
        return ResultsUtils.createTmsLink(link.value());
    }

    public static io.qameta.allure.model.Link createLink(String value, String name, String url, String type) {
        String resolvedName = ResultsUtils.firstNonEmpty(value).orElse(name);
        String resolvedUrl = ResultsUtils.firstNonEmpty(url).orElseGet(() -> ResultsUtils.getLinkUrl(resolvedName, type));
        return new io.qameta.allure.model.Link().withName(resolvedName).withUrl(resolvedUrl).withType(type);
    }

    public static String getHostName() {
        String fromProperty = System.getProperty(ALLURE_HOST_NAME_SYSPROP);
        String fromEnv = System.getenv(ALLURE_HOST_NAME_ENV);
        return Stream.of(fromProperty, fromEnv).filter(Objects::nonNull).findFirst().orElseGet(ResultsUtils::getRealHostName);
    }

    public static String getThreadName() {
        String fromProperty = System.getProperty(ALLURE_THREAD_NAME_SYSPROP);
        String fromEnv = System.getenv(ALLURE_THREAD_NAME_ENV);
        return Stream.of(fromProperty, fromEnv).filter(Objects::nonNull).findFirst().orElseGet(ResultsUtils::getRealThreadName);
    }

    public static Optional<Status> getStatus(Throwable throwable) {
        return Optional.ofNullable(throwable).map(t -> t instanceof AssertionError ? Status.FAILED : Status.BROKEN);
    }

    public static Optional<StatusDetails> getStatusDetails(Throwable e) {
        return Optional.ofNullable(e).map(throwable -> new StatusDetails().withMessage(throwable.getMessage()).withTrace(ResultsUtils.getStackTraceAsString(throwable)));
    }

    public static Optional<String> firstNonEmpty(String ... items) {
        return Stream.of(items).filter(Objects::nonNull).filter(item -> !item.isEmpty()).findFirst();
    }

    public static String getLinkTypePatternPropertyName(String type) {
        return String.format("allure.link.%s.pattern", type);
    }

    private static String getLinkUrl(String name, String type) {
        Properties properties = PropertiesUtils.loadAllureProperties();
        String pattern = properties.getProperty(ResultsUtils.getLinkTypePatternPropertyName(type));
        if (Objects.isNull(pattern)) {
            return null;
        }
        return pattern.replaceAll("\\{}", Objects.isNull(name) ? "" : name);
    }

    private static String getRealHostName() {
        if (Objects.isNull(cachedHost)) {
            try {
                cachedHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.debug("Could not get host name {}", (Throwable)e);
                cachedHost = "default";
            }
        }
        return cachedHost;
    }

    private static String getRealThreadName() {
        return String.format("%s.%s(%s)", ManagementFactory.getRuntimeMXBean().getName(), Thread.currentThread().getName(), Thread.currentThread().getId());
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void processDescription(ClassLoader classLoader, Method method, ExecutableItem item) {
        if (method.isAnnotationPresent(Description.class)) {
            if (method.getAnnotation(Description.class).useJavaDoc()) {
                String name = method.getName();
                List<String> parameterTypes = Stream.of(method.getParameterTypes()).map(Class::getTypeName).collect(Collectors.toList());
                String signatureHash = ResultsUtils.generateMethodSignatureHash(name, parameterTypes);
                try {
                    URL resource = Optional.ofNullable(classLoader.getResource(ALLURE_DESCRIPTIONS_PACKAGE + signatureHash)).orElseThrow(IOException::new);
                    String description = Resources.toString((URL)resource, (Charset)Charset.defaultCharset());
                    item.withDescriptionHtml(description);
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to process description resource file for method {} {}", (Object)name, (Object)e.getMessage());
                }
            } else {
                String description = method.getAnnotation(Description.class).value();
                item.withDescription(description);
            }
        }
    }

    public static String generateMethodSignatureHash(String methodName, List<String> parameterTypes) {
        MessageDigest hasher;
        try {
            hasher = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AllureResultsWriteException("Unable to instantiate MD5 hash generator", (Throwable)e);
        }
        String signature = methodName + parameterTypes.stream().collect(Collectors.joining(" "));
        return Base64.getUrlEncoder().encodeToString(hasher.digest(signature.getBytes(StandardCharsets.UTF_8)));
    }
}

