/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.test;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.qameta.allure.Allure;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.test.AllureResults;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Locale;

public final class AllureTestCommonsUtils {
    private static final ObjectWriter WRITER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME, true)).serializationInclusion(JsonInclude.Include.NON_DEFAULT)).build()).registerModule((Module)new SimpleModule().addSerializer(Status.class, (JsonSerializer)new StatusSerializer()).addSerializer(Stage.class, (JsonSerializer)new StageSerializer()).addSerializer(Parameter.Mode.class, (JsonSerializer)new ParameterModeSerializer())).writerWithDefaultPrettyPrinter();

    private AllureTestCommonsUtils() {
        throw new IllegalStateException("do not instance");
    }

    public static void attach(AllureResults allureResults) {
        allureResults.getTestResults().forEach(testResult -> {
            try {
                Allure.addAttachment((String)(testResult.getUuid() + "-result.json"), (String)WRITER.writeValueAsString(testResult));
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        });
        allureResults.getTestResultContainers().forEach(container -> {
            try {
                Allure.addAttachment((String)(container.getUuid() + "-container.json"), (String)WRITER.writeValueAsString(container));
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        });
        allureResults.getAttachments().forEach((fileName, body) -> Allure.addAttachment((String)fileName, (InputStream)new ByteArrayInputStream((byte[])body)));
    }

    private static class StatusSerializer
    extends StdSerializer<Status> {
        protected StatusSerializer() {
            super(Status.class);
        }

        public void serialize(Status value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.name().toLowerCase(Locale.ENGLISH));
        }
    }

    private static class StageSerializer
    extends StdSerializer<Stage> {
        protected StageSerializer() {
            super(Stage.class);
        }

        public void serialize(Stage value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.name().toLowerCase(Locale.ENGLISH));
        }
    }

    private static class ParameterModeSerializer
    extends StdSerializer<Parameter.Mode> {
        protected ParameterModeSerializer() {
            super(Parameter.Mode.class);
        }

        public void serialize(Parameter.Mode value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

