/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.tree;

import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.entity.Time;
import io.qameta.allure.tree.DefaultTreeLeaf;
import java.util.List;
import java.util.Set;

public class TestResultTreeLeaf
extends DefaultTreeLeaf {
    private final String uid;
    private final String parentUid;
    private final Status status;
    private final Time time;
    private final boolean flaky;
    private final boolean newFailed;
    private final boolean newPassed;
    private final boolean newBroken;
    private final int retriesCount;
    private final boolean retriesStatusChange;
    private final List<String> parameters;
    private final Set<String> tags;

    public TestResultTreeLeaf(String parentUid, TestResult testResult) {
        this(parentUid, testResult.getName(), testResult);
    }

    public TestResultTreeLeaf(String parentUid, String name, TestResult testResult) {
        super(name);
        this.parentUid = parentUid;
        this.uid = testResult.getUid();
        this.status = testResult.getStatus();
        this.time = testResult.getTime();
        this.flaky = testResult.isFlaky();
        this.newFailed = testResult.isNewFailed();
        this.newPassed = testResult.isNewPassed();
        this.newBroken = testResult.isNewBroken();
        this.retriesStatusChange = testResult.isRetriesStatusChange();
        this.retriesCount = testResult.getRetriesCount();
        this.parameters = testResult.getParameterValues();
        this.tags = (Set)testResult.getExtraBlock("tags");
    }

    public String getParentUid() {
        return this.parentUid;
    }

    public String getUid() {
        return this.uid;
    }

    public Status getStatus() {
        return this.status;
    }

    public Time getTime() {
        return this.time;
    }

    public boolean isFlaky() {
        return this.flaky;
    }

    public boolean isNewFailed() {
        return this.newFailed;
    }

    public boolean isNewPassed() {
        return this.newPassed;
    }

    public boolean isNewBroken() {
        return this.newBroken;
    }

    public int getRetriesCount() {
        return this.retriesCount;
    }

    public boolean isRetriesStatusChange() {
        return this.retriesStatusChange;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public Set<String> getTags() {
        return this.tags;
    }
}

