/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.assertj;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ObjectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AllureAspectJ {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureAspectJ.class);
    private static InheritableThreadLocal<AllureLifecycle> lifecycle = new InheritableThreadLocal<AllureLifecycle>(){

        @Override
        protected AllureLifecycle initialValue() {
            return Allure.getLifecycle();
        }
    };

    @Pointcut(value="execution(public org.assertj.core.api.AbstractAssert.new(..))")
    public void anyAssertCreation() {
    }

    @Pointcut(value="execution(public * org.assertj.core.api.AssertionsForClassTypes.*(..))")
    public void anyAssertCreation2() {
    }

    @Pointcut(value="execution(* org.assertj.core.api.AssertJProxySetup.*(..))")
    public void proxyMethod() {
    }

    @Pointcut(value="execution(public * org.assertj.core.api.AbstractAssert+.*(..)) && !proxyMethod()")
    public void anyAssert() {
    }

    @After(value="anyAssertCreation() || anyAssertCreation2()")
    public void logAssertCreation(JoinPoint joinPoint) {
        String actual = joinPoint.getArgs().length > 0 ? ObjectUtils.toString((Object)joinPoint.getArgs()[0]) : "<?>";
        String uuid = UUID.randomUUID().toString();
        String name = String.format("assertThat '%s'", actual);
        StepResult result = new StepResult().setName(name).setStatus(Status.PASSED);
        AllureAspectJ.getLifecycle().startStep(uuid, result);
        AllureAspectJ.getLifecycle().stopStep(uuid);
    }

    @Before(value="anyAssert()")
    public void stepStart(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String uuid = UUID.randomUUID().toString();
        String name = joinPoint.getArgs().length > 0 ? String.format("%s '%s'", methodSignature.getName(), AllureAspectJ.arrayToString(joinPoint.getArgs())) : methodSignature.getName();
        StepResult result = new StepResult().setName(name);
        AllureAspectJ.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="anyAssert()", throwing="e")
    public void stepFailed(Throwable e) {
        AllureAspectJ.getLifecycle().updateStep(s -> s.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)e).orElse(null)));
        AllureAspectJ.getLifecycle().stopStep();
    }

    @AfterReturning(pointcut="anyAssert()")
    public void stepStop() {
        AllureAspectJ.getLifecycle().updateStep(s -> s.setStatus(Status.PASSED));
        AllureAspectJ.getLifecycle().stopStep();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle.set(allure);
    }

    public static AllureLifecycle getLifecycle() {
        return (AllureLifecycle)lifecycle.get();
    }

    private static String arrayToString(Object ... array) {
        return Stream.of(array).map(ObjectUtils::toString).collect(Collectors.joining(" "));
    }
}

