/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.dropwizard.samplebuilder;

import io.prometheus.client.Collector;
import io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.GraphiteNamePattern;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CustomMappingSampleBuilder
implements SampleBuilder {
    private final List<CompiledMapperConfig> compiledMapperConfigs;
    private final DefaultSampleBuilder defaultMetricSampleBuilder = new DefaultSampleBuilder();

    public CustomMappingSampleBuilder(List<MapperConfig> mapperConfigs) {
        if (mapperConfigs == null || mapperConfigs.isEmpty()) {
            throw new IllegalArgumentException("CustomMappingSampleBuilder needs some mapper configs!");
        }
        this.compiledMapperConfigs = new ArrayList<CompiledMapperConfig>(mapperConfigs.size());
        for (MapperConfig config : mapperConfigs) {
            this.compiledMapperConfigs.add(new CompiledMapperConfig(config));
        }
    }

    @Override
    public Collector.MetricFamilySamples.Sample createSample(String dropwizardName, String nameSuffix, List<String> additionalLabelNames, List<String> additionalLabelValues, double value) {
        if (dropwizardName == null) {
            throw new IllegalArgumentException("Dropwizard metric name cannot be null");
        }
        CompiledMapperConfig matchingConfig = null;
        for (CompiledMapperConfig config : this.compiledMapperConfigs) {
            if (!config.pattern.matches(dropwizardName)) continue;
            matchingConfig = config;
            break;
        }
        if (matchingConfig != null) {
            Map<String, String> params = matchingConfig.pattern.extractParameters(dropwizardName);
            NameAndLabels nameAndLabels = this.getNameAndLabels(matchingConfig.mapperConfig, params);
            nameAndLabels.labelNames.addAll(additionalLabelNames);
            nameAndLabels.labelValues.addAll(additionalLabelValues);
            return this.defaultMetricSampleBuilder.createSample(nameAndLabels.name, nameSuffix, nameAndLabels.labelNames, nameAndLabels.labelValues, value);
        }
        return this.defaultMetricSampleBuilder.createSample(dropwizardName, nameSuffix, Collections.<String>emptyList(), Collections.<String>emptyList(), value);
    }

    protected NameAndLabels getNameAndLabels(MapperConfig config, Map<String, String> parameters) {
        String metricName = this.formatTemplate(config.getName(), parameters);
        ArrayList<String> labels = new ArrayList<String>(config.getLabels().size());
        ArrayList<String> labelValues = new ArrayList<String>(config.getLabels().size());
        for (Map.Entry<String, String> entry : config.getLabels().entrySet()) {
            labels.add(entry.getKey());
            labelValues.add(this.formatTemplate(entry.getValue(), parameters));
        }
        return new NameAndLabels(metricName, labels, labelValues);
    }

    private String formatTemplate(String template, Map<String, String> params) {
        String result = template;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    static class NameAndLabels {
        final String name;
        final List<String> labelNames;
        final List<String> labelValues;

        NameAndLabels(String name, List<String> labelNames, List<String> labelValues) {
            this.name = name;
            this.labelNames = labelNames;
            this.labelValues = labelValues;
        }
    }

    static class CompiledMapperConfig {
        final MapperConfig mapperConfig;
        final GraphiteNamePattern pattern;

        CompiledMapperConfig(MapperConfig mapperConfig) {
            this.mapperConfig = mapperConfig;
            this.pattern = new GraphiteNamePattern(mapperConfig.getMatch());
        }
    }
}

