/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CollectorRegistry {
    public static final CollectorRegistry defaultRegistry = new CollectorRegistry();
    private final Set<Collector> collectors = Collections.newSetFromMap(new ConcurrentHashMap());

    public void register(Collector m) {
        this.collectors.add(m);
    }

    public void unregister(Collector m) {
        this.collectors.remove(m);
    }

    public void clear() {
        this.collectors.clear();
    }

    public Enumeration<Collector.MetricFamilySamples> metricFamilySamples() {
        return new MetricFamilySamplesEnumeration();
    }

    public Double getSampleValue(String name, String[] labelNames, String[] labelValues) {
        for (Collector.MetricFamilySamples metricFamilySamples : Collections.list(this.metricFamilySamples())) {
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                if (!sample.name.equals(name) || !Arrays.equals(sample.labelNames, labelNames) || !Arrays.equals(sample.labelValues.toArray(), labelValues)) continue;
                return new Double(sample.value);
            }
        }
        return null;
    }

    class MetricFamilySamplesEnumeration
    implements Enumeration<Collector.MetricFamilySamples> {
        private final Iterator<Collector> collectorIter;
        private Collector.MetricFamilySamples[] metricFamilySamples;
        private int metricFamilySamplesIndex;
        private Collector.MetricFamilySamples next;

        MetricFamilySamplesEnumeration() {
            this.collectorIter = CollectorRegistry.this.collectors.iterator();
            this.findNextElement();
        }

        private void findNextElement() {
            if (this.metricFamilySamples != null && this.metricFamilySamplesIndex < this.metricFamilySamples.length) {
                this.next = this.metricFamilySamples[this.metricFamilySamplesIndex];
                ++this.metricFamilySamplesIndex;
            } else {
                while (this.collectorIter.hasNext()) {
                    this.metricFamilySamplesIndex = 0;
                    this.metricFamilySamples = this.collectorIter.next().collect();
                    if (this.metricFamilySamples.length <= 0) continue;
                    this.next = this.metricFamilySamples[this.metricFamilySamplesIndex];
                    ++this.metricFamilySamplesIndex;
                    return;
                }
                this.next = null;
            }
        }

        @Override
        public Collector.MetricFamilySamples nextElement() {
            Collector.MetricFamilySamples current = this.next;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.findNextElement();
            return current;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }
    }
}

