/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.MultiSpanProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.NoopSpanProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.ReadWriteSpan;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.ReadableSpan;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface SpanProcessor
extends Closeable {
    public static SpanProcessor composite(SpanProcessor ... processors) {
        return SpanProcessor.composite(Arrays.asList(processors));
    }

    public static SpanProcessor composite(Iterable<SpanProcessor> processors) {
        ArrayList<SpanProcessor> processorsList = new ArrayList<SpanProcessor>();
        for (SpanProcessor processor : processors) {
            processorsList.add(processor);
        }
        if (processorsList.isEmpty()) {
            return NoopSpanProcessor.getInstance();
        }
        if (processorsList.size() == 1) {
            return (SpanProcessor)processorsList.get(0);
        }
        return MultiSpanProcessor.create(processorsList);
    }

    public void onStart(Context var1, ReadWriteSpan var2);

    public boolean isStartRequired();

    public void onEnd(ReadableSpan var1);

    public boolean isEndRequired();

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

