/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.api.trace.SpanBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.api.trace.Tracer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.api.trace.TracerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.SdkSpanBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.TracerSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.internal.TracerConfig;

final class SdkTracer
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private static final Tracer NOOP_TRACER = TracerProvider.noop().get("noop");
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final TracerConfig tracerConfig;

    SdkTracer(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, TracerConfig tracerConfig) {
        this.sharedState = sharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerConfig = tracerConfig;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (!this.tracerConfig.isEnabled()) {
            return NOOP_TRACER.spanBuilder(spanName);
        }
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationScopeInfo.getName());
            return tracer.spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

