/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.view;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.internal.RandomSupplier;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.data.LongExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.data.PointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.aggregator.Aggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.function.Supplier;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                Supplier<ExemplarReservoir<LongExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new LongLastValueAggregator(reservoirFactory, memoryMode);
            }
            case DOUBLE: {
                Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new DoubleLastValueAggregator(reservoirFactory, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        InstrumentType instrumentType = instrumentDescriptor.getType();
        return instrumentType == InstrumentType.OBSERVABLE_GAUGE || instrumentType == InstrumentType.GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

