/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.api.internal.Utils;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.InstrumentSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.InstrumentType;
import java.util.Objects;
import javax.annotation.Nullable;

public final class InstrumentSelectorBuilder {
    @Nullable
    private InstrumentType instrumentType;
    @Nullable
    private String instrumentName;
    @Nullable
    private String instrumentUnit;
    @Nullable
    private String meterName;
    @Nullable
    private String meterVersion;
    @Nullable
    private String meterSchemaUrl;

    InstrumentSelectorBuilder() {
    }

    public InstrumentSelectorBuilder setType(InstrumentType instrumentType) {
        Objects.requireNonNull(instrumentType, "instrumentType");
        this.instrumentType = instrumentType;
        return this;
    }

    public InstrumentSelectorBuilder setName(String name) {
        Objects.requireNonNull(name, "name");
        this.instrumentName = name;
        return this;
    }

    public InstrumentSelectorBuilder setUnit(String unit) {
        Objects.requireNonNull(unit, "unit");
        this.instrumentUnit = unit;
        return this;
    }

    public InstrumentSelectorBuilder setMeterName(String meterName) {
        Objects.requireNonNull(meterName, "meterName");
        this.meterName = meterName;
        return this;
    }

    public InstrumentSelectorBuilder setMeterVersion(String meterVersion) {
        Objects.requireNonNull(meterVersion, "meterVersion");
        this.meterVersion = meterVersion;
        return this;
    }

    public InstrumentSelectorBuilder setMeterSchemaUrl(String meterSchemaUrl) {
        Objects.requireNonNull(meterSchemaUrl, "meterSchemaUrl");
        this.meterSchemaUrl = meterSchemaUrl;
        return this;
    }

    public InstrumentSelector build() {
        Utils.checkArgument(this.instrumentType != null || this.instrumentName != null || this.instrumentUnit != null || this.meterName != null || this.meterVersion != null || this.meterSchemaUrl != null, "Instrument selector must contain selection criteria");
        return InstrumentSelector.create(this.instrumentType, this.instrumentName, this.instrumentUnit, this.meterName, this.meterVersion, this.meterSchemaUrl);
    }
}

