/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.sender.okhttp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.okhttp3.Interceptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.okhttp3.Response;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class RetryInterceptor
implements Interceptor {
    private final RetryPolicy retryPolicy;
    private final Function<Response, Boolean> isRetryable;
    private final Function<IOException, Boolean> isRetryableException;
    private final Sleeper sleeper;
    private final BoundedLongGenerator randomLong;

    public RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable) {
        this(retryPolicy, isRetryable, RetryInterceptor::isRetryableException, TimeUnit.NANOSECONDS::sleep, bound -> ThreadLocalRandom.current().nextLong(bound));
    }

    RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable, Function<IOException, Boolean> isRetryableException, Sleeper sleeper, BoundedLongGenerator randomLong) {
        this.retryPolicy = retryPolicy;
        this.isRetryable = isRetryable;
        this.isRetryableException = isRetryableException;
        this.sleeper = sleeper;
        this.randomLong = randomLong;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = null;
        IOException exception = null;
        int attempt = 0;
        long nextBackoffNanos = this.retryPolicy.getInitialBackoff().toNanos();
        do {
            if (attempt > 0) {
                long upperBoundNanos = Math.min(nextBackoffNanos, this.retryPolicy.getMaxBackoff().toNanos());
                long backoffNanos = this.randomLong.get(upperBoundNanos);
                nextBackoffNanos = (long)((double)nextBackoffNanos * this.retryPolicy.getBackoffMultiplier());
                try {
                    this.sleeper.sleep(backoffNanos);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (response != null) {
                    response.close();
                }
            }
            ++attempt;
            try {
                response = chain.proceed(chain.request());
            }
            catch (IOException e) {
                exception = e;
            }
            if (response != null && !Boolean.TRUE.equals(this.isRetryable.apply(response))) {
                return response;
            }
            if (exception == null || Boolean.TRUE.equals(this.isRetryableException.apply(exception))) continue;
            throw exception;
        } while (attempt < this.retryPolicy.getMaxAttempts());
        if (response != null) {
            return response;
        }
        throw exception;
    }

    static boolean isRetryableException(IOException e) {
        if (!(e instanceof SocketTimeoutException)) {
            return false;
        }
        String message = e.getMessage();
        return message == null || message.toLowerCase(Locale.ROOT).contains("connect timed out");
    }

    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }

    static interface BoundedLongGenerator {
        public long get(long var1);
    }
}

