/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.grpc.GrpcExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.grpc.GrpcExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.metrics.LowAllocationMetricsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.export.AggregationTemporalitySelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.export.DefaultAggregationSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.export.MetricExporter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private final Deque<LowAllocationMetricsRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationMetricsRequestMarshaler>();
    private final GrpcExporterBuilder<Marshaler> builder;
    private final GrpcExporter<Marshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;
    private final MemoryMode memoryMode;

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    OtlpGrpcMetricExporter(GrpcExporterBuilder<Marshaler> builder, GrpcExporter<Marshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
        this.memoryMode = memoryMode;
    }

    public OtlpGrpcMetricExporterBuilder toBuilder() {
        return new OtlpGrpcMetricExporterBuilder(this.builder.copy(), this.memoryMode);
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationMetricsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationMetricsRequestMarshaler();
            }
            LowAllocationMetricsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(metrics);
            return this.delegate.export(exportMarshaler, metrics.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.delegate.export(request, metrics.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpGrpcMetricExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("aggregationTemporalitySelector=" + AggregationTemporalitySelector.asString(this.aggregationTemporalitySelector));
        joiner.add("defaultAggregationSelector=" + DefaultAggregationSelector.asString(this.defaultAggregationSelector));
        joiner.add("memoryMode=" + (Object)((Object)this.memoryMode));
        return joiner.toString();
    }
}

