/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.otlp.http.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.traces.LowAllocationTraceRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.data.SpanData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.trace.export.SpanExporter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpSpanExporter
implements SpanExporter {
    private final Deque<LowAllocationTraceRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationTraceRequestMarshaler>();
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    private final MemoryMode memoryMode;

    OtlpHttpSpanExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.memoryMode = memoryMode;
    }

    public static OtlpHttpSpanExporter getDefault() {
        return OtlpHttpSpanExporter.builder().build();
    }

    public static OtlpHttpSpanExporterBuilder builder() {
        return new OtlpHttpSpanExporterBuilder();
    }

    public OtlpHttpSpanExporterBuilder toBuilder() {
        return new OtlpHttpSpanExporterBuilder(this.builder.copy(), this.memoryMode);
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationTraceRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationTraceRequestMarshaler();
            }
            LowAllocationTraceRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(spans);
            return this.delegate.export(exportMarshaler, spans.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.delegate.export(request, spans.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpSpanExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.memoryMode));
        return joiner.toString();
    }
}

