/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.otlp.http.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.logs.LowAllocationLogsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.logs.export.LogRecordExporter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpLogRecordExporter
implements LogRecordExporter {
    private final Deque<LowAllocationLogsRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationLogsRequestMarshaler>();
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    private final MemoryMode memoryMode;

    OtlpHttpLogRecordExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.memoryMode = memoryMode;
    }

    public static OtlpHttpLogRecordExporter getDefault() {
        return OtlpHttpLogRecordExporter.builder().build();
    }

    public static OtlpHttpLogRecordExporterBuilder builder() {
        return new OtlpHttpLogRecordExporterBuilder();
    }

    public OtlpHttpLogRecordExporterBuilder toBuilder() {
        return new OtlpHttpLogRecordExporterBuilder(this.builder.copy(), this.memoryMode);
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationLogsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationLogsRequestMarshaler();
            }
            LowAllocationLogsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(logs);
            return this.delegate.export(exportMarshaler, logs.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        LogsRequestMarshaler request = LogsRequestMarshaler.create(logs);
        return this.delegate.export(request, logs.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpLogRecordExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.memoryMode));
        return joiner.toString();
    }
}

