/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.InstrumentationScopeMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.proto.metrics.v1.internal.ScopeMetrics;
import java.io.IOException;
import java.util.List;

final class InstrumentationScopeMetricsMarshaler
extends MarshalerWithSize {
    private final InstrumentationScopeMarshaler instrumentationScope;
    private final List<Marshaler> metricMarshalers;
    private final byte[] schemaUrlUtf8;

    InstrumentationScopeMetricsMarshaler(InstrumentationScopeMarshaler instrumentationScope, byte[] schemaUrlUtf8, List<Marshaler> metricMarshalers) {
        super(InstrumentationScopeMetricsMarshaler.calculateSize(instrumentationScope, schemaUrlUtf8, metricMarshalers));
        this.instrumentationScope = instrumentationScope;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.metricMarshalers = metricMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ScopeMetrics.SCOPE, this.instrumentationScope);
        output.serializeRepeatedMessage(ScopeMetrics.METRICS, this.metricMarshalers);
        output.serializeString(ScopeMetrics.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(InstrumentationScopeMarshaler instrumentationScope, byte[] schemaUrlUtf8, List<Marshaler> metricMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ScopeMetrics.SCOPE, instrumentationScope);
        size += MarshalerUtil.sizeBytes(ScopeMetrics.SCHEMA_URL, schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage(ScopeMetrics.METRICS, metricMarshalers);
    }
}

