/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.api.internal.ConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.WireFormat;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CodedOutputStream {
    private static final int DEFAULT_BUFFER_SIZE;
    private static final ThreadLocal<OutputStreamEncoder> THREAD_LOCAL_CODED_OUTPUT_STREAM;

    static CodedOutputStream newInstance(OutputStream output) {
        OutputStreamEncoder cos = THREAD_LOCAL_CODED_OUTPUT_STREAM.get();
        if (cos == null) {
            cos = new OutputStreamEncoder(output);
            THREAD_LOCAL_CODED_OUTPUT_STREAM.set(cos);
        } else {
            cos.reset(output);
        }
        return cos;
    }

    private CodedOutputStream() {
    }

    final void writeRawBytes(byte[] value) throws IOException {
        this.write(value, 0, value.length);
    }

    abstract void writeInt32NoTag(int var1) throws IOException;

    abstract void writeUInt32NoTag(int var1) throws IOException;

    final void writeSInt32NoTag(int value) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(value));
    }

    abstract void writeFixed32NoTag(int var1) throws IOException;

    final void writeSFixed32NoTag(int value) throws IOException {
        this.writeFixed32NoTag(value);
    }

    final void writeInt64NoTag(long value) throws IOException {
        this.writeUInt64NoTag(value);
    }

    abstract void writeUInt64NoTag(long var1) throws IOException;

    final void writeSInt64NoTag(long value) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(value));
    }

    abstract void writeFixed64NoTag(long var1) throws IOException;

    final void writeSFixed64NoTag(long value) throws IOException {
        this.writeFixed64NoTag(value);
    }

    final void writeFloatNoTag(float value) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(value));
    }

    final void writeDoubleNoTag(double value) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(value));
    }

    final void writeBoolNoTag(boolean value) throws IOException {
        this.write((byte)(value ? 1 : 0));
    }

    final void writeEnumNoTag(int value) throws IOException {
        this.writeInt32NoTag(value);
    }

    final void writeByteArrayNoTag(byte[] value) throws IOException {
        this.writeByteArrayNoTag(value, 0, value.length);
    }

    abstract void write(byte var1) throws IOException;

    abstract void write(byte[] var1, int var2, int var3) throws IOException;

    static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(value);
        }
        return 10;
    }

    static int computeUInt32SizeNoTag(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int computeSInt32SizeNoTag(int value) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value));
    }

    static int computeFixed32SizeNoTag(int unused) {
        return 4;
    }

    static int computeSFixed32SizeNoTag(int unused) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    static int computeUInt64SizeNoTag(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value < 0L) {
            return 10;
        }
        int n = 2;
        if ((value & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value >>>= 28;
        }
        if ((value & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value >>>= 14;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    static int computeSInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value));
    }

    static int computeFixed64SizeNoTag(long unused) {
        return 8;
    }

    static int computeSFixed64SizeNoTag(long unused) {
        return 8;
    }

    static int computeFloatSizeNoTag(float unused) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double unused) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean unused) {
        return 1;
    }

    static int computeEnumSizeNoTag(int value) {
        return CodedOutputStream.computeInt32SizeNoTag(value);
    }

    public static int computeByteArraySizeNoTag(byte[] value) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value.length);
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        return CodedOutputStream.computeUInt32SizeNoTag(fieldLength) + fieldLength;
    }

    static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    abstract void flush() throws IOException;

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    static {
        int bufferSize = 51200;
        try {
            String bufferSizeConfig = ConfigUtil.getString("otel.experimental.otlp.buffer-size", "");
            if (!bufferSizeConfig.isEmpty()) {
                bufferSize = Integer.parseInt(bufferSizeConfig);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_BUFFER_SIZE = bufferSize;
        THREAD_LOCAL_CODED_OUTPUT_STREAM = new ThreadLocal();
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private OutputStream out;

        OutputStreamEncoder(OutputStream out) {
            super(DEFAULT_BUFFER_SIZE);
            this.out = out;
        }

        void reset(OutputStream out) {
            this.out = out;
            this.position = 0;
            this.totalBytesWritten = 0;
        }

        @Override
        void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value, offset, length);
        }

        @Override
        void write(byte value) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(value);
        }

        @Override
        void writeInt32NoTag(int value) throws IOException {
            if (value >= 0) {
                this.writeUInt32NoTag(value);
            } else {
                this.writeUInt64NoTag(value);
            }
        }

        @Override
        void writeUInt32NoTag(int value) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(value);
        }

        @Override
        void writeFixed32NoTag(int value) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(value);
        }

        @Override
        void writeUInt64NoTag(long value) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(value);
        }

        @Override
        void writeFixed64NoTag(long value) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(value);
        }

        @Override
        void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        void write(byte[] value, int offset, int length) throws IOException {
            if (this.limit - this.position >= length) {
                System.arraycopy(value, offset, this.buffer, this.position, length);
                this.position += length;
                this.totalBytesWritten += length;
            } else {
                int bytesWritten = this.limit - this.position;
                System.arraycopy(value, offset, this.buffer, this.position, bytesWritten);
                offset += bytesWritten;
                this.position = this.limit;
                this.totalBytesWritten += bytesWritten;
                this.doFlush();
                if ((length -= bytesWritten) <= this.limit) {
                    System.arraycopy(value, offset, this.buffer, 0, length);
                    this.position = length;
                } else {
                    this.out.write(value, offset, length);
                }
                this.totalBytesWritten += length;
            }
        }

        private void flushIfNotAvailable(int requiredSize) throws IOException {
            if (this.limit - this.position < requiredSize) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        AbstractBufferedEncoder(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.limit = this.buffer.length;
        }

        final void buffer(byte value) {
            this.buffer[this.position++] = value;
            ++this.totalBytesWritten;
        }

        final void bufferUInt32NoTag(int value) {
            while (true) {
                if ((value & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)value;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
                ++this.totalBytesWritten;
                value >>>= 7;
            }
        }

        final void bufferUInt64NoTag(long value) {
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)value;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)value & 0x7F | 0x80);
                ++this.totalBytesWritten;
                value >>>= 7;
            }
        }

        final void bufferFixed32NoTag(int value) {
            this.buffer[this.position++] = (byte)(value & 0xFF);
            this.buffer[this.position++] = (byte)(value >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(value >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(value >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long value) {
            this.buffer[this.position++] = (byte)(value & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)((int)(value >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }
    }
}

