/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.concurrent;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.concurrent.LongAdder;
import java.util.concurrent.atomic.AtomicLong;

final class AtomicLongLongAdder
implements LongAdder {
    private final AtomicLong atomicLong = new AtomicLong();

    AtomicLongLongAdder() {
    }

    @Override
    public void add(long x) {
        long next;
        long current;
        while (!this.atomicLong.compareAndSet(current = this.atomicLong.get(), next = current + x)) {
        }
    }

    @Override
    public long sum() {
        return this.atomicLong.get();
    }

    @Override
    public void reset() {
        this.atomicLong.set(0L);
    }

    @Override
    public long sumThenReset() {
        long prev;
        while (!this.atomicLong.compareAndSet(prev = this.atomicLong.get(), 0L)) {
        }
        return prev;
    }

    public String toString() {
        return Long.toString(this.sum());
    }
}

