/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.internal.aggregator;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.Aggregation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AggregationUtil {
    private static final Map<String, Aggregation> aggregationByName = new HashMap<String, Aggregation>();
    private static final Map<Class<? extends Aggregation>, String> nameByAggregation;
    private static final String AGGREGATION_DEFAULT = "default";
    private static final String AGGREGATION_SUM = "sum";
    private static final String AGGREGATION_LAST_VALUE = "last_value";
    private static final String AGGREGATION_DROP = "drop";
    private static final String AGGREGATION_EXPLICIT_BUCKET_HISTOGRAM = "explicit_bucket_histogram";
    private static final String AGGREGATION_BASE2_EXPONENTIAL_HISTOGRAM = "base2_exponential_bucket_histogram";

    private AggregationUtil() {
    }

    public static Aggregation forName(String name) {
        Aggregation aggregation = aggregationByName.get(name.toLowerCase(Locale.ROOT));
        if (aggregation == null) {
            throw new IllegalArgumentException("Unrecognized aggregation name " + name);
        }
        return aggregation;
    }

    public static String aggregationName(Aggregation aggregation) {
        String name = nameByAggregation.get(aggregation.getClass());
        if (name == null) {
            throw new IllegalStateException("Unrecognized aggregation " + aggregation.getClass().getName());
        }
        return name;
    }

    static {
        aggregationByName.put(AGGREGATION_DEFAULT, Aggregation.defaultAggregation());
        aggregationByName.put(AGGREGATION_SUM, Aggregation.sum());
        aggregationByName.put(AGGREGATION_LAST_VALUE, Aggregation.lastValue());
        aggregationByName.put(AGGREGATION_DROP, Aggregation.drop());
        aggregationByName.put(AGGREGATION_EXPLICIT_BUCKET_HISTOGRAM, Aggregation.explicitBucketHistogram());
        aggregationByName.put(AGGREGATION_BASE2_EXPONENTIAL_HISTOGRAM, Aggregation.base2ExponentialBucketHistogram());
        nameByAggregation = new HashMap<Class<? extends Aggregation>, String>();
        nameByAggregation.put(Aggregation.defaultAggregation().getClass(), AGGREGATION_DEFAULT);
        nameByAggregation.put(Aggregation.sum().getClass(), AGGREGATION_SUM);
        nameByAggregation.put(Aggregation.lastValue().getClass(), AGGREGATION_LAST_VALUE);
        nameByAggregation.put(Aggregation.drop().getClass(), AGGREGATION_DROP);
        nameByAggregation.put(Aggregation.explicitBucketHistogram().getClass(), AGGREGATION_EXPLICIT_BUCKET_HISTOGRAM);
        nameByAggregation.put(Aggregation.base2ExponentialBucketHistogram().getClass(), AGGREGATION_BASE2_EXPONENTIAL_HISTOGRAM);
    }
}

