/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.internal.JavaVersionSpecific;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SystemClock
implements Clock {
    private static final SystemClock INSTANCE = new SystemClock();

    private SystemClock() {
    }

    static Clock getInstance() {
        return INSTANCE;
    }

    @Override
    public long now() {
        return this.now(true);
    }

    @Override
    public long now(boolean highPrecision) {
        if (highPrecision) {
            return JavaVersionSpecific.get().currentTimeNanos();
        }
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    public String toString() {
        return "SystemClock{}";
    }
}

