/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.proto.metrics.v1.internal.SummaryDataPoint;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.metrics.data.ValueAtQuantile;
import java.io.IOException;
import java.util.List;

final class ValueAtQuantileMarshaler
extends MarshalerWithSize {
    private final double quantile;
    private final double value;

    static ValueAtQuantileMarshaler[] createRepeated(List<ValueAtQuantile> values2) {
        int numValues = values2.size();
        ValueAtQuantileMarshaler[] marshalers = new ValueAtQuantileMarshaler[numValues];
        for (int i = 0; i < numValues; ++i) {
            marshalers[i] = ValueAtQuantileMarshaler.create(values2.get(i));
        }
        return marshalers;
    }

    private static ValueAtQuantileMarshaler create(ValueAtQuantile value) {
        return new ValueAtQuantileMarshaler(value.getQuantile(), value.getValue());
    }

    private ValueAtQuantileMarshaler(double quantile, double value) {
        super(ValueAtQuantileMarshaler.calculateSize(quantile, value));
        this.quantile = quantile;
        this.value = value;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeDouble(SummaryDataPoint.ValueAtQuantile.QUANTILE, this.quantile);
        output.serializeDouble(SummaryDataPoint.ValueAtQuantile.VALUE, this.value);
    }

    static int calculateSize(double quantile, double value) {
        int size = 0;
        size += MarshalerUtil.sizeDouble(SummaryDataPoint.ValueAtQuantile.QUANTILE, quantile);
        return size += MarshalerUtil.sizeDouble(SummaryDataPoint.ValueAtQuantile.VALUE, value);
    }
}

