/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.exporter.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_1_38_0.sdk.common.export.MemoryMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.Consumer;

public final class ExporterBuilderUtil {
    public static URI validateEndpoint(String endpoint) {
        URI uri;
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint, must be a URL: " + endpoint, e);
        }
        if (uri.getScheme() == null || !uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("Invalid endpoint, must start with http:// or https://: " + uri);
        }
        return uri;
    }

    public static void configureExporterMemoryMode(ConfigProperties config, Consumer<MemoryMode> memoryModeConsumer) {
        MemoryMode memoryMode;
        String memoryModeStr = config.getString("otel.java.experimental.exporter.memory_mode");
        if (memoryModeStr == null) {
            return;
        }
        try {
            memoryMode = MemoryMode.valueOf(memoryModeStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Unrecognized memory mode: " + memoryModeStr, e);
        }
        memoryModeConsumer.accept(memoryMode);
    }

    private ExporterBuilderUtil() {
    }
}

