/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.trace.data;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.trace.SpanContext;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.trace.SpanKind;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.InstrumentationLibraryInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.internal.InstrumentationScopeUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.trace.data.EventData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.trace.data.LinkData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.trace.data.StatusData;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanData {
    public String getName();

    public SpanKind getKind();

    public SpanContext getSpanContext();

    default public String getTraceId() {
        return this.getSpanContext().getTraceId();
    }

    default public String getSpanId() {
        return this.getSpanContext().getSpanId();
    }

    public SpanContext getParentSpanContext();

    default public String getParentSpanId() {
        return this.getParentSpanContext().getSpanId();
    }

    public StatusData getStatus();

    public long getStartEpochNanos();

    public Attributes getAttributes();

    public List<EventData> getEvents();

    public List<LinkData> getLinks();

    public long getEndEpochNanos();

    public boolean hasEnded();

    public int getTotalRecordedEvents();

    public int getTotalRecordedLinks();

    public int getTotalAttributeCount();

    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    default public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return InstrumentationScopeUtil.toInstrumentationScopeInfo(this.getInstrumentationLibraryInfo());
    }

    public Resource getResource();
}

