/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.logs.LoggerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.logs.LoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.internal.ComponentRegistry;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.LogLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.LogRecordProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.LoggerSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.NoopLogRecordProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.SdkLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.SdkLoggerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.SdkLoggerProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.Resource;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkLoggerProvider
implements LoggerProvider,
Closeable {
    static final String DEFAULT_LOGGER_NAME = "unknown";
    private static final Logger LOGGER = Logger.getLogger(SdkLoggerProvider.class.getName());
    private final LoggerSharedState sharedState;
    private final ComponentRegistry<SdkLogger> loggerComponentRegistry;
    private final boolean isNoopLogRecordProcessor;

    public static SdkLoggerProviderBuilder builder() {
        return new SdkLoggerProviderBuilder();
    }

    SdkLoggerProvider(Resource resource, Supplier<LogLimits> logLimitsSupplier, List<LogRecordProcessor> processors, Clock clock) {
        LogRecordProcessor logRecordProcessor = LogRecordProcessor.composite(processors);
        this.sharedState = new LoggerSharedState(resource, logLimitsSupplier, logRecordProcessor, clock);
        this.loggerComponentRegistry = new ComponentRegistry<SdkLogger>(instrumentationScopeInfo -> new SdkLogger(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo));
        this.isNoopLogRecordProcessor = logRecordProcessor instanceof NoopLogRecordProcessor;
    }

    @Override
    public io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.logs.Logger get(String instrumentationScopeName) {
        return this.loggerComponentRegistry.get(SdkLoggerProvider.instrumentationNameOrDefault(instrumentationScopeName), null, null, Attributes.empty());
    }

    @Override
    public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
        if (this.isNoopLogRecordProcessor) {
            return LoggerProvider.noop().loggerBuilder(instrumentationScopeName);
        }
        return new SdkLoggerBuilder(this.loggerComponentRegistry, SdkLoggerProvider.instrumentationNameOrDefault(instrumentationScopeName));
    }

    private static String instrumentationNameOrDefault(@Nullable String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            LOGGER.fine("Logger requested without instrumentation scope name.");
            return DEFAULT_LOGGER_NAME;
        }
        return instrumentationScopeName;
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogRecordProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkLoggerProvider{clock=" + this.sharedState.getClock() + ", resource=" + this.sharedState.getResource() + ", logLimits=" + this.sharedState.getLogLimits() + ", logRecordProcessor=" + this.sharedState.getLogRecordProcessor() + '}';
    }
}

