/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace;

import com.google.auto.value.AutoValue;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.trace.SpanContext;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.trace.SpanKind;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.InstrumentationLibraryInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.internal.InstrumentationScopeUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.AutoValue_SpanWrapper;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.SdkSpan;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.data.EventData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.data.LinkData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.data.SpanData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.data.StatusData;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class SpanWrapper
implements SpanData {
    SpanWrapper() {
    }

    abstract SdkSpan delegate();

    abstract List<LinkData> resolvedLinks();

    abstract List<EventData> resolvedEvents();

    abstract Attributes attributes();

    abstract int totalAttributeCount();

    abstract int totalRecordedEvents();

    abstract StatusData status();

    abstract String name();

    abstract long endEpochNanos();

    abstract boolean internalHasEnded();

    static SpanWrapper create(SdkSpan delegate, List<LinkData> links, List<EventData> events, Attributes attributes, int totalAttributeCount, int totalRecordedEvents, StatusData status, String name, long endEpochNanos, boolean hasEnded) {
        return new AutoValue_SpanWrapper(delegate, links, events, attributes, totalAttributeCount, totalRecordedEvents, status, name, endEpochNanos, hasEnded);
    }

    @Override
    public SpanContext getSpanContext() {
        return this.delegate().getSpanContext();
    }

    @Override
    public SpanContext getParentSpanContext() {
        return this.delegate().getParentSpanContext();
    }

    @Override
    public Resource getResource() {
        return this.delegate().getResource();
    }

    @Override
    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return InstrumentationScopeUtil.toInstrumentationLibraryInfo(this.delegate().getInstrumentationScopeInfo());
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.delegate().getInstrumentationScopeInfo();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public SpanKind getKind() {
        return this.delegate().getKind();
    }

    @Override
    public long getStartEpochNanos() {
        return this.delegate().getStartEpochNanos();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes();
    }

    @Override
    public List<EventData> getEvents() {
        return this.resolvedEvents();
    }

    @Override
    public List<LinkData> getLinks() {
        return this.resolvedLinks();
    }

    @Override
    public StatusData getStatus() {
        return this.status();
    }

    @Override
    public long getEndEpochNanos() {
        return this.endEpochNanos();
    }

    @Override
    public boolean hasEnded() {
        return this.internalHasEnded();
    }

    @Override
    public int getTotalRecordedEvents() {
        return this.totalRecordedEvents();
    }

    @Override
    public int getTotalRecordedLinks() {
        return this.delegate().getTotalRecordedLinks();
    }

    @Override
    public int getTotalAttributeCount() {
        return this.totalAttributeCount();
    }

    public final String toString() {
        return "SpanData{spanContext=" + this.getSpanContext() + ", parentSpanContext=" + this.getParentSpanContext() + ", resource=" + this.getResource() + ", instrumentationScopeInfo=" + this.getInstrumentationScopeInfo() + ", name=" + this.getName() + ", kind=" + (Object)((Object)this.getKind()) + ", startEpochNanos=" + this.getStartEpochNanos() + ", endEpochNanos=" + this.getEndEpochNanos() + ", attributes=" + this.getAttributes() + ", totalAttributeCount=" + this.getTotalAttributeCount() + ", events=" + this.getEvents() + ", totalRecordedEvents=" + this.getTotalRecordedEvents() + ", links=" + this.getLinks() + ", totalRecordedLinks=" + this.getTotalRecordedLinks() + ", status=" + this.getStatus() + ", hasEnded=" + this.hasEnded() + "}";
    }
}

