/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.trace.SpanId;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.trace.TraceId;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.internal.RandomSupplier;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.IdGenerator;
import java.util.Random;
import java.util.function.Supplier;

enum RandomIdGenerator implements IdGenerator
{
    INSTANCE;

    private static final long INVALID_ID = 0L;
    private static final Supplier<Random> randomSupplier;

    @Override
    public String generateSpanId() {
        long id;
        Random random = randomSupplier.get();
        while ((id = random.nextLong()) == 0L) {
        }
        return SpanId.fromLong(id);
    }

    @Override
    public String generateTraceId() {
        long idLo;
        Random random = randomSupplier.get();
        long idHi = random.nextLong();
        while ((idLo = random.nextLong()) == 0L) {
        }
        return TraceId.fromLongs(idHi, idLo);
    }

    public String toString() {
        return "RandomIdGenerator{}";
    }

    static {
        randomSupplier = RandomSupplier.platformDefault();
    }
}

