/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.view;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.internal.RandomSupplier;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.LongExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.PointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.aggregator.Aggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.aggregator.DoubleSumAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.aggregator.LongSumAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.function.Supplier;

public final class SumAggregation
implements Aggregation,
AggregatorFactory {
    private static final SumAggregation INSTANCE = new SumAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private SumAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                Supplier<ExemplarReservoir<LongExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new LongSumAggregator(instrumentDescriptor, reservoirFactory);
            }
            case DOUBLE: {
                Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new DoubleSumAggregator(instrumentDescriptor, reservoirFactory);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case OBSERVABLE_COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "SumAggregation";
    }
}

