/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.LongExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.concurrent.AdderUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.concurrent.LongAdder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.ReservoirCell;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class RandomFixedSizeExemplarReservoir<T extends ExemplarData>
extends FixedSizeExemplarReservoir<T> {
    private RandomFixedSizeExemplarReservoir(Clock clock, int size, Supplier<Random> randomSupplier, BiFunction<ReservoirCell, Attributes, T> mapAndResetCell) {
        super(clock, size, new RandomCellSelector(randomSupplier), mapAndResetCell);
    }

    static RandomFixedSizeExemplarReservoir<LongExemplarData> createLong(Clock clock, int size, Supplier<Random> randomSupplier) {
        return new RandomFixedSizeExemplarReservoir<LongExemplarData>(clock, size, randomSupplier, ReservoirCell::getAndResetLong);
    }

    static RandomFixedSizeExemplarReservoir<DoubleExemplarData> createDouble(Clock clock, int size, Supplier<Random> randomSupplier) {
        return new RandomFixedSizeExemplarReservoir<DoubleExemplarData>(clock, size, randomSupplier, ReservoirCell::getAndResetDouble);
    }

    static class RandomCellSelector
    implements ReservoirCellSelector {
        private final LongAdder numMeasurements = AdderUtil.createLongAdder();
        private final Supplier<Random> randomSupplier;

        private RandomCellSelector(Supplier<Random> randomSupplier) {
            this.randomSupplier = randomSupplier;
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, long value, Attributes attributes, Context context) {
            return this.reservoirCellIndex(cells);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, double value, Attributes attributes, Context context) {
            return this.reservoirCellIndex(cells);
        }

        private int reservoirCellIndex(ReservoirCell[] cells) {
            int count;
            int index = this.randomSupplier.get().nextInt((count = this.numMeasurements.intValue() + 1) > 0 ? count : 1);
            this.numMeasurements.increment();
            if (index < cells.length) {
                return index;
            }
            return -1;
        }

        @Override
        public void reset() {
            this.numMeasurements.reset();
        }
    }
}

