/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.LongExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.FilteredExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.HistogramExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.NoopExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.RandomFixedSizeExemplarReservoir;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;

public interface ExemplarReservoir<T extends ExemplarData> {
    public static <T extends ExemplarData> ExemplarReservoir<T> filtered(ExemplarFilter filter, ExemplarReservoir<T> original) {
        return new FilteredExemplarReservoir<T>(filter, original);
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleNoSamples() {
        return NoopExemplarReservoir.DOUBLE_INSTANCE;
    }

    public static ExemplarReservoir<LongExemplarData> longNoSamples() {
        return NoopExemplarReservoir.LONG_INSTANCE;
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createDouble(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<LongExemplarData> longFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createLong(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<DoubleExemplarData> histogramBucketReservoir(Clock clock, List<Double> boundaries) {
        return new HistogramExemplarReservoir(clock, boundaries);
    }

    public void offerDoubleMeasurement(double var1, Attributes var3, Context var4);

    public void offerLongMeasurement(long var1, Attributes var3, Context var4);

    public List<T> collectAndReset(Attributes var1);
}

