/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.debug;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.debug.SourceInfo;

final class StackTraceSourceInfo
implements SourceInfo {
    private final StackTraceElement[] stackTraceElements;

    StackTraceSourceInfo(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    @Override
    public String shortDebugString() {
        if (this.stackTraceElements.length > 0) {
            for (StackTraceElement e : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e)) continue;
                return String.format("%s:%d", e.getFileName(), e.getLineNumber());
            }
        }
        return "unknown source";
    }

    @Override
    public String multiLineDebugString() {
        if (this.stackTraceElements.length > 0) {
            StringBuilder result = new StringBuilder();
            for (StackTraceElement e : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e)) continue;
                result.append("\tat ").append(e).append("\n");
            }
            return result.toString();
        }
        return "\tat unknown source";
    }

    private static boolean isInterestingStackTrace(StackTraceElement e) {
        return !e.getClassName().startsWith("io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics") && !e.getClassName().startsWith("java.lang");
    }
}

