/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.aggregator;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.DoublePointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.concurrent.AdderUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.concurrent.DoubleAdder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.data.ImmutableMetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.data.ImmutableSumData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.data.MutableDoublePointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.state.Measurement;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public final class DoubleSumAggregator
extends AbstractSumAggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoublePointData diff(DoublePointData previousPoint, DoublePointData currentPoint) {
        return ImmutableDoublePointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public void diffInPlace(DoublePointData previousReusablePoint, DoublePointData currentPoint) {
        ((MutableDoublePointData)previousReusablePoint).set(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousReusablePoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public void toPoint(Measurement measurement, DoublePointData reusablePoint) {
        ((MutableDoublePointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        private final DoubleAdder current = AdderUtil.createDoubleAdder();

        Handle(ExemplarReservoir<DoubleExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            double value = reset ? this.current.sumThenReset() : this.current.sum();
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(value);
        }
    }
}

