/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.metrics.LongHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.extension.incubator.metrics.ExtendedLongHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.internal.ThrottlingLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.AbstractInstrumentBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.descriptor.Advice;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.state.MeterProviderSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.state.MeterSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class SdkLongHistogram
extends AbstractInstrument
implements LongHistogram {
    private static final Logger logger = Logger.getLogger(SdkLongHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkLongHistogram(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void record(long value, Attributes attributes, Context context) {
        if (value < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(value, attributes, context);
    }

    @Override
    public void record(long value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    static final class SdkLongHistogramBuilder
    extends AbstractInstrumentBuilder<SdkLongHistogramBuilder>
    implements ExtendedLongHistogramBuilder {
        SdkLongHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            super(meterProviderSharedState, sharedState, InstrumentType.HISTOGRAM, InstrumentValueType.LONG, name, description, unit, adviceBuilder);
        }

        @Override
        protected SdkLongHistogramBuilder getThis() {
            return this;
        }

        @Override
        public SdkLongHistogram build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkLongHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ExtendedLongHistogramBuilder setExplicitBucketBoundariesAdvice(List<Long> bucketBoundaries) {
            List<Double> doubleBoundaries = bucketBoundaries.stream().map(Long::doubleValue).collect(Collectors.toList());
            this.adviceBuilder.setExplicitBucketBoundaries(doubleBoundaries);
            return this;
        }

        @Override
        public ExtendedLongHistogramBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.adviceBuilder.setAttributes(attributes);
            return this;
        }
    }
}

