/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.logs.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.events.EventEmitter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.events.EventEmitterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.events.EventEmitterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.logs.Logger;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.logs.LoggerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.logs.LoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.Clock;
import java.util.concurrent.TimeUnit;

public final class SdkEventEmitterProvider
implements EventEmitterProvider {
    private static final String DEFAULT_EVENT_DOMAIN = "unknown";
    private final LoggerProvider delegateLoggerProvider;
    private final Clock clock;

    private SdkEventEmitterProvider(LoggerProvider delegateLoggerProvider, Clock clock) {
        this.delegateLoggerProvider = delegateLoggerProvider;
        this.clock = clock;
    }

    public static SdkEventEmitterProvider create(LoggerProvider delegateLoggerProvider) {
        return new SdkEventEmitterProvider(delegateLoggerProvider, Clock.getDefault());
    }

    public static SdkEventEmitterProvider create(LoggerProvider delegateLoggerProvider, Clock clock) {
        return new SdkEventEmitterProvider(delegateLoggerProvider, clock);
    }

    @Override
    public EventEmitter get(String instrumentationScopeName) {
        return this.eventEmitterBuilder(instrumentationScopeName).setEventDomain(DEFAULT_EVENT_DOMAIN).build();
    }

    @Override
    public EventEmitterBuilder eventEmitterBuilder(String instrumentationScopeName) {
        return new SdkEventEmitterBuilder(this.clock, this.delegateLoggerProvider.loggerBuilder(instrumentationScopeName));
    }

    private static class SdkEventEmitterBuilder
    implements EventEmitterBuilder {
        private final Clock clock;
        private final LoggerBuilder delegateLoggerBuilder;
        private String eventDomain = "unknown";

        private SdkEventEmitterBuilder(Clock clock, LoggerBuilder delegateLoggerBuilder) {
            this.clock = clock;
            this.delegateLoggerBuilder = delegateLoggerBuilder;
        }

        @Override
        public EventEmitterBuilder setEventDomain(String eventDomain) {
            this.eventDomain = eventDomain;
            return this;
        }

        @Override
        public EventEmitterBuilder setSchemaUrl(String schemaUrl) {
            this.delegateLoggerBuilder.setSchemaUrl(schemaUrl);
            return this;
        }

        @Override
        public EventEmitterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegateLoggerBuilder.setInstrumentationVersion(instrumentationScopeVersion);
            return this;
        }

        @Override
        public EventEmitter build() {
            return new SdkEventEmitter(this.clock, this.delegateLoggerBuilder.build(), this.eventDomain);
        }
    }

    private static class SdkEventEmitter
    implements EventEmitter {
        private static final AttributeKey<String> EVENT_DOMAIN = AttributeKey.stringKey("event.domain");
        private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey("event.name");
        private final Clock clock;
        private final Logger delegateLogger;
        private final String eventDomain;

        private SdkEventEmitter(Clock clock, Logger delegateLogger, String eventDomain) {
            this.clock = clock;
            this.delegateLogger = delegateLogger;
            this.eventDomain = eventDomain;
        }

        @Override
        public void emit(String eventName, Attributes attributes) {
            this.delegateLogger.logRecordBuilder().setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS).setAllAttributes(attributes).setAttribute(EVENT_DOMAIN, this.eventDomain).setAttribute(EVENT_NAME, eventName).emit();
        }
    }
}

