/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.sender.okhttp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.RetryUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.auth.Authenticator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.http.HttpSender;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.sender.okhttp.internal.OkHttpUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.sender.okhttp.internal.RetryInterceptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Call;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Callback;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.HttpUrl;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.MediaType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.OkHttpClient;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Request;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.RequestBody;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Response;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.ResponseBody;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okio.BufferedSink;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okio.GzipSink;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okio.Okio;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OkHttpHttpSender
implements HttpSender {
    private final OkHttpClient client;
    private final HttpUrl url;
    private final boolean compressionEnabled;
    private final Supplier<Map<String, String>> headerSupplier;
    private final MediaType mediaType;

    public OkHttpHttpSender(String endpoint, boolean compressionEnabled, String contentType, long timeoutNanos, Supplier<Map<String, String>> headerSupplier, @Nullable Authenticator authenticator, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofNanos(timeoutNanos));
        if (authenticator != null) {
            Authenticator finalAuthenticator = authenticator;
            builder.authenticator((route, response) -> {
                Request.Builder requestBuilder = response.request().newBuilder();
                finalAuthenticator.getHeaders().forEach(requestBuilder::header);
                return requestBuilder.build();
            });
        }
        if (retryPolicy != null) {
            builder.addInterceptor(new RetryInterceptor(retryPolicy, OkHttpHttpSender::isRetryable));
        }
        if (sslContext != null && trustManager != null) {
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        this.client = builder.build();
        this.url = HttpUrl.get(endpoint);
        this.compressionEnabled = compressionEnabled;
        this.mediaType = MediaType.parse(contentType);
        this.headerSupplier = headerSupplier;
    }

    @Override
    public void send(Consumer<OutputStream> marshaler, int contentLength, final Consumer<HttpSender.Response> onResponse, final Consumer<Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        this.headerSupplier.get().forEach(requestBuilder::addHeader);
        RawRequestBody body = new RawRequestBody(marshaler, contentLength, this.mediaType);
        if (this.compressionEnabled) {
            requestBuilder.addHeader("Content-Encoding", "gzip");
            requestBuilder.post(new GzipRequestBody(body));
        } else {
            requestBuilder.post(body);
        }
        this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                onError.accept(e);
            }

            @Override
            public void onResponse(Call call, final Response response) {
                try (final ResponseBody body = response.body();){
                    onResponse.accept(new HttpSender.Response(){

                        @Override
                        public int statusCode() {
                            return response.code();
                        }

                        @Override
                        public String statusMessage() {
                            return response.message();
                        }

                        @Override
                        public byte[] responseBody() throws IOException {
                            return body.bytes();
                        }
                    });
                }
            }
        });
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    static boolean isRetryable(Response response) {
        return RetryUtil.retryableHttpResponseCodes().contains(response.code());
    }

    private static class RawRequestBody
    extends RequestBody {
        private final Consumer<OutputStream> marshaler;
        private final int contentLength;
        private final MediaType mediaType;

        private RawRequestBody(Consumer<OutputStream> marshaler, int contentLength, MediaType mediaType) {
            this.marshaler = marshaler;
            this.contentLength = contentLength;
            this.mediaType = mediaType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public MediaType contentType() {
            return this.mediaType;
        }

        @Override
        public void writeTo(BufferedSink bufferedSink) {
            this.marshaler.accept(bufferedSink.outputStream());
        }
    }

    private static class GzipRequestBody
    extends RequestBody {
        private final RequestBody requestBody;

        private GzipRequestBody(RequestBody requestBody) {
            this.requestBody = requestBody;
        }

        @Override
        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        @Override
        public long contentLength() {
            return -1L;
        }

        @Override
        public void writeTo(BufferedSink bufferedSink) throws IOException {
            BufferedSink gzipSink = Okio.buffer(new GzipSink(bufferedSink));
            this.requestBody.writeTo(gzipSink);
            gzipSink.close();
        }
    }
}

