/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.sender.okhttp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.RetryUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.grpc.GrpcResponse;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.grpc.GrpcSender;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.sender.okhttp.internal.GrpcRequestBody;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.sender.okhttp.internal.OkHttpUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.sender.okhttp.internal.RetryInterceptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Call;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Callback;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Headers;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.HttpUrl;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.OkHttpClient;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Protocol;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Request;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.okhttp3.Response;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OkHttpGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private final OkHttpClient client;
    private final HttpUrl url;
    private final Headers headers;
    private final boolean compressionEnabled;

    public OkHttpGrpcSender(String endpoint, boolean compressionEnabled, long timeoutNanos, Map<String, String> headers, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofNanos(timeoutNanos));
        if (retryPolicy != null) {
            clientBuilder.addInterceptor(new RetryInterceptor(retryPolicy, OkHttpGrpcSender::isRetryable));
        }
        if (sslContext != null && trustManager != null) {
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        if (endpoint.startsWith("http://")) {
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
        }
        this.client = clientBuilder.build();
        Headers.Builder headersBuilder = new Headers.Builder();
        headers.forEach(headersBuilder::add);
        headersBuilder.add("te", "trailers");
        if (compressionEnabled) {
            headersBuilder.add("grpc-encoding", "gzip");
        }
        this.headers = headersBuilder.build();
        this.url = HttpUrl.get(endpoint);
        this.compressionEnabled = compressionEnabled;
    }

    @Override
    public void send(T request, final Runnable onSuccess, final BiConsumer<GrpcResponse, Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url).headers(this.headers);
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)request, this.compressionEnabled);
        requestBuilder.post(requestBody);
        this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                String description = e.getMessage();
                if (description == null) {
                    description = "";
                }
                onError.accept(GrpcResponse.create(2, description), e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                int statusCode;
                try {
                    response.body().bytes();
                }
                catch (IOException e) {
                    onError.accept(GrpcResponse.create(2, "Could not consume server response."), e);
                    return;
                }
                String status = OkHttpGrpcSender.grpcStatus(response);
                if ("0".equals(status)) {
                    onSuccess.run();
                    return;
                }
                String errorMessage = OkHttpGrpcSender.grpcMessage(response);
                try {
                    statusCode = Integer.parseInt(status);
                }
                catch (NumberFormatException ex) {
                    statusCode = 2;
                }
                onError.accept(GrpcResponse.create(statusCode, errorMessage), new IllegalStateException(errorMessage));
            }
        });
    }

    @Nullable
    private static String grpcStatus(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response) {
        String message = response.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcSender.unescape(message);
        }
        return response.message();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    public static boolean isRetryable(Response response) {
        if (!response.isSuccessful()) {
            return false;
        }
        String grpcStatus = response.header(GRPC_STATUS);
        return RetryUtil.retryableGrpcStatusCodes().contains(grpcStatus);
    }

    private static String unescape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value.length())) continue;
            return OkHttpGrpcSender.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i = 0;
        while (i < value.length) {
            if (value[i] == 37 && i + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

