/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.otlp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.otlp.internal.OtlpConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.logs.export.LogRecordExporter;

public class OtlpLogRecordExporterProvider
implements ConfigurableLogRecordExporterProvider {
    @Override
    public LogRecordExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("logs", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpLogRecordExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcLogRecordExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP logs protocol: " + protocol);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpLogRecordExporterBuilder httpBuilder() {
        return OtlpHttpLogRecordExporter.builder();
    }

    OtlpGrpcLogRecordExporterBuilder grpcBuilder() {
        return OtlpGrpcLogRecordExporter.builder();
    }
}

