/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.trace.StatusCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.ProtoEnumInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.proto.trace.v1.internal.Status;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.trace.data.StatusData;
import java.io.IOException;

final class SpanStatusMarshaler
extends MarshalerWithSize {
    private final ProtoEnumInfo protoStatusCode;
    private final byte[] descriptionUtf8;

    static SpanStatusMarshaler create(StatusData status) {
        ProtoEnumInfo protoStatusCode = Status.StatusCode.STATUS_CODE_UNSET;
        if (status.getStatusCode() == StatusCode.OK) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_OK;
        } else if (status.getStatusCode() == StatusCode.ERROR) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_ERROR;
        }
        byte[] description = MarshalerUtil.toBytes(status.getDescription());
        return new SpanStatusMarshaler(protoStatusCode, description);
    }

    private SpanStatusMarshaler(ProtoEnumInfo protoStatusCode, byte[] descriptionUtf8) {
        super(SpanStatusMarshaler.computeSize(protoStatusCode, descriptionUtf8));
        this.protoStatusCode = protoStatusCode;
        this.descriptionUtf8 = descriptionUtf8;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeString(Status.MESSAGE, this.descriptionUtf8);
        output.serializeEnum(Status.CODE, this.protoStatusCode);
    }

    private static int computeSize(ProtoEnumInfo protoStatusCode, byte[] descriptionUtf8) {
        int size = 0;
        size += MarshalerUtil.sizeBytes(Status.MESSAGE, descriptionUtf8);
        return size += MarshalerUtil.sizeEnum(Status.CODE, protoStatusCode);
    }
}

