/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.otlp.InstrumentationScopeMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.otlp.traces.SpanMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.proto.trace.v1.internal.ScopeSpans;
import java.io.IOException;
import java.util.List;

final class InstrumentationScopeSpansMarshaler
extends MarshalerWithSize {
    private final InstrumentationScopeMarshaler instrumentationScope;
    private final List<SpanMarshaler> spanMarshalers;
    private final byte[] schemaUrlUtf8;

    InstrumentationScopeSpansMarshaler(InstrumentationScopeMarshaler instrumentationScope, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        super(InstrumentationScopeSpansMarshaler.calculateSize(instrumentationScope, schemaUrlUtf8, spanMarshalers));
        this.instrumentationScope = instrumentationScope;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.spanMarshalers = spanMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ScopeSpans.SCOPE, this.instrumentationScope);
        output.serializeRepeatedMessage(ScopeSpans.SPANS, this.spanMarshalers);
        output.serializeString(ScopeSpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(InstrumentationScopeMarshaler instrumentationScope, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ScopeSpans.SCOPE, instrumentationScope);
        size += MarshalerUtil.sizeBytes(ScopeSpans.SCHEMA_URL, schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage(ScopeSpans.SPANS, spanMarshalers);
    }
}

