/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.internal.PrimitiveLongList;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.metrics.data.ExponentialHistogramBuckets;
import java.io.IOException;
import java.util.List;

public class ExponentialHistogramBucketsMarshaler
extends MarshalerWithSize {
    private final int offset;
    private final List<Long> counts;

    static ExponentialHistogramBucketsMarshaler create(ExponentialHistogramBuckets buckets) {
        return new ExponentialHistogramBucketsMarshaler(buckets.getOffset(), buckets.getBucketCounts());
    }

    private ExponentialHistogramBucketsMarshaler(int offset, List<Long> counts) {
        super(ExponentialHistogramBucketsMarshaler.calculateSize(offset, counts));
        this.offset = offset;
        this.counts = counts;
    }

    @Override
    protected void writeTo(Serializer output) throws IOException {
        output.serializeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, this.offset);
        output.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray(this.counts));
    }

    private static int calculateSize(int offset, List<Long> counts) {
        int size = 0;
        size += MarshalerUtil.sizeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, offset);
        return size += MarshalerUtil.sizeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray(counts));
    }
}

