/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.trace.SpanId;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.trace.TraceId;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.CodedOutputStream;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.ProtoEnumInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.sdk.resources.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MarshalerUtil {
    private static final int TRACE_ID_VALUE_SIZE = CodedOutputStream.computeLengthDelimitedFieldSize(TraceId.getLength() / 2);
    private static final int SPAN_ID_VALUE_SIZE = CodedOutputStream.computeLengthDelimitedFieldSize(SpanId.getLength() / 2);
    private static final boolean JSON_AVAILABLE;
    private static final byte[] EMPTY_BYTES;

    public static <T, U> Map<Resource, Map<InstrumentationScopeInfo, List<U>>> groupByResourceAndScope(Collection<T> dataList, Function<T, Resource> getResource, Function<T, InstrumentationScopeInfo> getInstrumentationScope, Function<T, U> createMarshaler) {
        IdentityHashMap<Resource, Map<InstrumentationScopeInfo, List<U>>> result = new IdentityHashMap<Resource, Map<InstrumentationScopeInfo, List<U>>>(8);
        for (T data : dataList) {
            Map scopeInfoListMap = result.computeIfAbsent(getResource.apply(data), unused -> new IdentityHashMap(8));
            List marshalerList = scopeInfoListMap.computeIfAbsent(getInstrumentationScope.apply(data), unused -> new ArrayList());
            marshalerList.add(createMarshaler.apply(data));
        }
        return result;
    }

    public static String preserializeJsonFields(Marshaler marshaler) {
        if (!JSON_AVAILABLE) {
            return "";
        }
        ByteArrayOutputStream jsonBos = new ByteArrayOutputStream();
        try {
            marshaler.writeJsonTo(jsonBos);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
        }
        byte[] jsonBytes = jsonBos.toByteArray();
        return new String(jsonBytes, 1, jsonBytes.length - 2, StandardCharsets.UTF_8);
    }

    public static int sizeRepeatedFixed64(ProtoFieldInfo field, List<Long> values2) {
        return MarshalerUtil.sizeRepeatedFixed64(field, values2.size());
    }

    private static int sizeRepeatedFixed64(ProtoFieldInfo field, int numValues) {
        if (numValues == 0) {
            return 0;
        }
        int dataSize = 8 * numValues;
        int size = 0;
        size += field.getTagSize();
        return size += CodedOutputStream.computeLengthDelimitedFieldSize(dataSize);
    }

    public static int sizeRepeatedUInt64(ProtoFieldInfo field, long[] values2) {
        if (values2.length == 0) {
            return 0;
        }
        int payloadSize = 0;
        for (long v : values2) {
            payloadSize += CodedOutputStream.computeUInt64SizeNoTag(v);
        }
        return field.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(payloadSize) + payloadSize;
    }

    public static int sizeRepeatedDouble(ProtoFieldInfo field, List<Double> values2) {
        return MarshalerUtil.sizeRepeatedFixed64(field, values2.size());
    }

    public static <T extends Marshaler> int sizeRepeatedMessage(ProtoFieldInfo field, T[] repeatedMessage) {
        int size = 0;
        int fieldTagSize = field.getTagSize();
        for (T message : repeatedMessage) {
            int fieldSize = ((Marshaler)message).getBinarySerializedSize();
            size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
        return size;
    }

    public static int sizeRepeatedMessage(ProtoFieldInfo field, List<? extends Marshaler> repeatedMessage) {
        int size = 0;
        int fieldTagSize = field.getTagSize();
        for (Marshaler marshaler : repeatedMessage) {
            int fieldSize = marshaler.getBinarySerializedSize();
            size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
        return size;
    }

    public static int sizeMessage(ProtoFieldInfo field, Marshaler message) {
        int fieldSize = message.getBinarySerializedSize();
        return field.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
    }

    public static int sizeBool(ProtoFieldInfo field, boolean value) {
        if (!value) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeBoolSizeNoTag(value);
    }

    public static int sizeInt64(ProtoFieldInfo field, long message) {
        if (message == 0L) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeInt64SizeNoTag(message);
    }

    public static int sizeUInt32(ProtoFieldInfo field, int message) {
        if (message == 0) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(message);
    }

    public static int sizeSInt32(ProtoFieldInfo field, int message) {
        if (message == 0) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeSInt32SizeNoTag(message);
    }

    public static int sizeInt32(ProtoFieldInfo field, int message) {
        if (message == 0) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeInt32SizeNoTag(message);
    }

    public static int sizeDouble(ProtoFieldInfo field, double value) {
        if (value == 0.0) {
            return 0;
        }
        return MarshalerUtil.sizeDoubleOptional(field, value);
    }

    public static int sizeDoubleOptional(ProtoFieldInfo field, double value) {
        return field.getTagSize() + CodedOutputStream.computeDoubleSizeNoTag(value);
    }

    public static int sizeFixed64(ProtoFieldInfo field, long value) {
        if (value == 0L) {
            return 0;
        }
        return MarshalerUtil.sizeFixed64Optional(field, value);
    }

    public static int sizeFixed64Optional(ProtoFieldInfo field, long value) {
        return field.getTagSize() + CodedOutputStream.computeFixed64SizeNoTag(value);
    }

    public static int sizeFixed32(ProtoFieldInfo field, int message) {
        if ((long)message == 0L) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeFixed32SizeNoTag(message);
    }

    public static int sizeBytes(ProtoFieldInfo field, byte[] message) {
        if (message.length == 0) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(message);
    }

    public static int sizeEnum(ProtoFieldInfo field, ProtoEnumInfo enumValue) {
        int number = enumValue.getEnumNumber();
        if (number == 0) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeEnumSizeNoTag(number);
    }

    public static int sizeTraceId(ProtoFieldInfo field, @Nullable String traceId) {
        if (traceId == null) {
            return 0;
        }
        return field.getTagSize() + TRACE_ID_VALUE_SIZE;
    }

    public static int sizeSpanId(ProtoFieldInfo field, @Nullable String spanId) {
        if (spanId == null) {
            return 0;
        }
        return field.getTagSize() + SPAN_ID_VALUE_SIZE;
    }

    public static byte[] toBytes(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return EMPTY_BYTES;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private MarshalerUtil() {
    }

    static {
        boolean jsonAvailable = false;
        try {
            Class.forName("com.fasterxml.jackson.core.JsonFactory");
            jsonAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JSON_AVAILABLE = jsonAvailable;
        EMPTY_BYTES = new byte[0];
    }
}

