/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.propagation;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.propagation.MultiTextMapPropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.propagation.NoopTextMapPropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.propagation.TextMapGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface TextMapPropagator {
    public static TextMapPropagator composite(TextMapPropagator ... propagators) {
        return TextMapPropagator.composite(Arrays.asList(propagators));
    }

    public static TextMapPropagator composite(Iterable<TextMapPropagator> propagators) {
        ArrayList<TextMapPropagator> propagatorsList = new ArrayList<TextMapPropagator>();
        for (TextMapPropagator propagator : propagators) {
            propagatorsList.add(propagator);
        }
        if (propagatorsList.isEmpty()) {
            return NoopTextMapPropagator.getInstance();
        }
        if (propagatorsList.size() == 1) {
            return (TextMapPropagator)propagatorsList.get(0);
        }
        return new MultiTextMapPropagator(propagatorsList);
    }

    public static TextMapPropagator noop() {
        return NoopTextMapPropagator.getInstance();
    }

    public Collection<String> fields();

    public <C> void inject(Context var1, @Nullable C var2, TextMapSetter<C> var3);

    public <C> Context extract(Context var1, @Nullable C var2, TextMapGetter<C> var3);
}

