/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common;

import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.ArrayBackedAttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_1_31_0.api.common.Attributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public interface AttributesBuilder {
    public Attributes build();

    public <T> AttributesBuilder put(AttributeKey<Long> var1, int var2);

    public <T> AttributesBuilder put(AttributeKey<T> var1, T var2);

    default public AttributesBuilder put(String key, String value) {
        return this.put(AttributeKey.stringKey(key), (T)value);
    }

    default public AttributesBuilder put(String key, long value) {
        return this.put((AttributeKey<T>)AttributeKey.longKey(key), (T)value);
    }

    default public AttributesBuilder put(String key, double value) {
        return this.put(AttributeKey.doubleKey(key), (T)value);
    }

    default public AttributesBuilder put(String key, boolean value) {
        return this.put(AttributeKey.booleanKey(key), (T)value);
    }

    default public AttributesBuilder put(String key, String ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.stringArrayKey(key), (T)Arrays.asList(value));
    }

    default public <T> AttributesBuilder put(AttributeKey<List<T>> key, T ... value) {
        if (value == null) {
            return this;
        }
        return this.put((AttributeKey<T>)key, (T)Arrays.asList(value));
    }

    default public AttributesBuilder put(String key, long ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.longArrayKey(key), (T)ArrayBackedAttributesBuilder.toList(value));
    }

    default public AttributesBuilder put(String key, double ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.doubleArrayKey(key), (T)ArrayBackedAttributesBuilder.toList(value));
    }

    default public AttributesBuilder put(String key, boolean ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.booleanArrayKey(key), (T)ArrayBackedAttributesBuilder.toList(value));
    }

    public AttributesBuilder putAll(Attributes var1);

    default public <T> AttributesBuilder remove(AttributeKey<T> key) {
        return this;
    }

    default public AttributesBuilder removeIf(Predicate<AttributeKey<?>> filter) {
        return this;
    }
}

