/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.ContextStorage;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.Scope;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

enum ThreadLocalContextStorage implements ContextStorage
{
    INSTANCE;

    private static final Logger logger;
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE;

    @Override
    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set(toAttach);
        return new ScopeImpl(beforeAttach, toAttach);
    }

    @Override
    @Nullable
    public Context current() {
        return THREAD_LOCAL_STORAGE.get();
    }

    static {
        logger = Logger.getLogger(ThreadLocalContextStorage.class.getName());
        THREAD_LOCAL_STORAGE = new ThreadLocal();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }

    private class ScopeImpl
    implements Scope {
        @Nullable
        private final Context beforeAttach;
        private final Context toAttach;
        private boolean closed;

        private ScopeImpl(Context beforeAttach, Context toAttach) {
            this.beforeAttach = beforeAttach;
            this.toAttach = toAttach;
        }

        @Override
        public void close() {
            if (!this.closed && ThreadLocalContextStorage.this.current() == this.toAttach) {
                this.closed = true;
                THREAD_LOCAL_STORAGE.set(this.beforeAttach);
            } else {
                logger.log(Level.FINE, " Trying to close scope which does not represent current context. Ignoring the call.");
            }
        }
    }
}

