/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.ContextStorage;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.ContextStorageProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.ContextStorageWrappers;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.StrictContextStorage;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LazyStorage {
    private static final String CONTEXT_STORAGE_PROVIDER_PROPERTY = "io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.contextStorageProvider";
    private static final String ENFORCE_DEFAULT_STORAGE_VALUE = "default";
    private static final String ENABLE_STRICT_CONTEXT_PROVIDER_PROPERTY = "io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.enableStrictContext";
    private static final Logger logger = Logger.getLogger(LazyStorage.class.getName());
    private static final ContextStorage storage;

    static ContextStorage get() {
        return storage;
    }

    static ContextStorage createStorage(AtomicReference<Throwable> deferredStorageFailure) {
        String providerClassName = System.getProperty(CONTEXT_STORAGE_PROVIDER_PROPERTY, "");
        if (ENFORCE_DEFAULT_STORAGE_VALUE.equals(providerClassName)) {
            return ContextStorage.defaultStorage();
        }
        ArrayList<ContextStorageProvider> providers = new ArrayList<ContextStorageProvider>();
        for (ContextStorageProvider provider : ServiceLoader.load(ContextStorageProvider.class)) {
            if (provider.getClass().getName().equals("io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.testing.context.SettableContextStorageProvider")) {
                return provider.get();
            }
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            return ContextStorage.defaultStorage();
        }
        if (providerClassName.isEmpty()) {
            if (providers.size() == 1) {
                return ((ContextStorageProvider)providers.get(0)).get();
            }
            deferredStorageFailure.set(new IllegalStateException("Found multiple ContextStorageProvider. Set the io.opentelemetry.context.ContextStorageProvider property to the fully qualified class name of the provider to use. Falling back to default ContextStorage. Found providers: " + providers));
            return ContextStorage.defaultStorage();
        }
        for (ContextStorageProvider provider : providers) {
            if (!provider.getClass().getName().equals(providerClassName)) continue;
            return provider.get();
        }
        deferredStorageFailure.set(new IllegalStateException("io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.ContextStorageProvider property set but no matching class could be found, requested: " + providerClassName + " but found providers: " + providers));
        return ContextStorage.defaultStorage();
    }

    private LazyStorage() {
    }

    static {
        AtomicReference<Throwable> deferredStorageFailure = new AtomicReference<Throwable>();
        ContextStorage created = LazyStorage.createStorage(deferredStorageFailure);
        if (Boolean.getBoolean(ENABLE_STRICT_CONTEXT_PROVIDER_PROPERTY)) {
            created = StrictContextStorage.create(created);
        }
        for (Function<? super ContextStorage, ? extends ContextStorage> wrapper : ContextStorageWrappers.getWrappers()) {
            created = wrapper.apply(created);
        }
        storage = created;
        ContextStorageWrappers.setStorageInitialized();
        Throwable failure = deferredStorageFailure.get();
        if (failure != null) {
            logger.log(Level.WARNING, "ContextStorageProvider initialized failed. Using default", failure);
        }
    }
}

