/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.internal.PrimitiveLongList;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.HistogramPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.Aggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableHistogramData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableHistogramPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableMetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class DoubleExplicitBucketHistogramAggregator
implements Aggregator<HistogramPointData, DoubleExemplarData> {
    private final double[] boundaries;
    private final List<Double> boundaryList;
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleExplicitBucketHistogramAggregator(double[] boundaries, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier) {
        this.boundaries = boundaries;
        ArrayList<Double> boundaryList = new ArrayList<Double>(this.boundaries.length);
        for (double v : this.boundaries) {
            boundaryList.add(v);
        }
        this.boundaryList = Collections.unmodifiableList(boundaryList);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<HistogramPointData, DoubleExemplarData> createHandle() {
        return new Handle(this.boundaryList, this.boundaries, this.reservoirSupplier.get());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<HistogramPointData> pointData, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableHistogramData.create(temporality, pointData));
    }

    static final class Handle
    extends AggregatorHandle<HistogramPointData, DoubleExemplarData> {
        private final List<Double> boundaryList;
        private final double[] boundaries;
        private double sum;
        private double min;
        private double max;
        private long count;
        private final long[] counts;
        private final ReentrantLock lock = new ReentrantLock();

        Handle(List<Double> boundaryList, double[] boundaries, ExemplarReservoir<DoubleExemplarData> reservoir) {
            super(reservoir);
            this.boundaryList = boundaryList;
            this.boundaries = boundaries;
            this.counts = new long[this.boundaries.length + 1];
            this.sum = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HistogramPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            this.lock.lock();
            try {
                ImmutableHistogramPointData pointData = ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes, this.sum, this.count > 0L, this.min, this.count > 0L, this.max, this.boundaryList, PrimitiveLongList.wrap(Arrays.copyOf(this.counts, this.counts.length)), exemplars);
                if (reset) {
                    this.sum = 0.0;
                    this.min = Double.MAX_VALUE;
                    this.max = -1.0;
                    this.count = 0L;
                    Arrays.fill(this.counts, 0L);
                }
                ImmutableHistogramPointData immutableHistogramPointData = pointData;
                return immutableHistogramPointData;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double value) {
            int bucketIndex = ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
            this.lock.lock();
            try {
                this.sum += value;
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
                ++this.count;
                int n = bucketIndex;
                this.counts[n] = this.counts[n] + 1L;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }
    }
}

