/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.logs.Severity;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.trace.SpanContext;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.internal.AttributesMap;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.logs.LogLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.logs.ReadWriteLogRecord;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.logs.SdkLogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.logs.data.Body;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SdkReadWriteLogRecord
implements ReadWriteLogRecord {
    private final LogLimits logLimits;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long timestampEpochNanos;
    private final long observedTimestampEpochNanos;
    private final SpanContext spanContext;
    private final Severity severity;
    @Nullable
    private final String severityText;
    private final Body body;
    private final Object lock = new Object();
    @Nullable
    private AttributesMap attributes;

    private SdkReadWriteLogRecord(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, Body body, @Nullable AttributesMap attributes) {
        this.logLimits = logLimits;
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.body = body;
        this.attributes = attributes;
    }

    static SdkReadWriteLogRecord create(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, Body body, @Nullable AttributesMap attributes) {
        return new SdkReadWriteLogRecord(logLimits, resource, instrumentationScopeInfo, timestampEpochNanos, observedTimestampEpochNanos, spanContext, severity, severityText, body, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteLogRecord setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getImmutableAttributes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return Attributes.empty();
            }
            return this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecordData toLogRecordData() {
        Object object = this.lock;
        synchronized (object) {
            return SdkLogRecordData.create(this.resource, this.instrumentationScopeInfo, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.body, this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues());
        }
    }
}

