/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.GlobalOpenTelemetry;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.context.propagation.ContextPropagators;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.OpenTelemetrySdk;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.logs.SdkLoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.SdkMeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.trace.SdkTracerProvider;
import javax.annotation.Nullable;

public final class OpenTelemetrySdkBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;
    @Nullable
    private SdkMeterProvider meterProvider;
    @Nullable
    private SdkLoggerProvider loggerProvider;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setMeterProvider(SdkMeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setLoggerProvider(SdkLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        this.propagators = propagators;
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk sdk = this.build();
        GlobalOpenTelemetry.set(sdk);
        return sdk;
    }

    public OpenTelemetrySdk build() {
        SdkLoggerProvider loggerProvider;
        SdkMeterProvider meterProvider;
        SdkTracerProvider tracerProvider = this.tracerProvider;
        if (tracerProvider == null) {
            tracerProvider = SdkTracerProvider.builder().build();
        }
        if ((meterProvider = this.meterProvider) == null) {
            meterProvider = SdkMeterProvider.builder().build();
        }
        if ((loggerProvider = this.loggerProvider) == null) {
            loggerProvider = SdkLoggerProvider.builder().build();
        }
        return new OpenTelemetrySdk(tracerProvider, meterProvider, loggerProvider, this.propagators);
    }
}

