/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.view;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.internal.Utils;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.internal.RandomSupplier;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.PointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.Aggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.DoubleBase2ExponentialHistogramAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class Base2ExponentialHistogramAggregation
implements Aggregation,
AggregatorFactory {
    private static final int DEFAULT_MAX_BUCKETS = 160;
    private static final int DEFAULT_MAX_SCALE = 20;
    private static final Aggregation DEFAULT = new Base2ExponentialHistogramAggregation(160, 20);
    private final int maxBuckets;
    private final int maxScale;

    private Base2ExponentialHistogramAggregation(int maxBuckets, int maxScale) {
        this.maxBuckets = maxBuckets;
        this.maxScale = maxScale;
    }

    public static Aggregation getDefault() {
        return DEFAULT;
    }

    public static Aggregation create(int maxBuckets, int maxScale) {
        Utils.checkArgument(maxBuckets >= 1, "maxBuckets must be > 0");
        Utils.checkArgument(maxScale <= 20 && maxScale >= -10, "maxScale must be -10 <= x <= 20");
        return new Base2ExponentialHistogramAggregation(maxBuckets, maxScale);
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return new DoubleBase2ExponentialHistogramAggregator(() -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault())), this.maxBuckets, this.maxScale);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Base2ExponentialHistogramAggregation{maxBuckets=" + this.maxBuckets + ",maxScale=" + this.maxScale + "}";
    }
}

