/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data;

import com.google.auto.value.AutoValue;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.internal.PrimitiveLongList;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.HistogramPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.AutoValue_ImmutableHistogramPointData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableHistogramPointData
implements HistogramPointData {
    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min, boolean hasMax, double max, List<Double> boundaries, List<Long> counts) {
        return ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes, sum, hasMin, min, hasMax, max, boundaries, counts, Collections.emptyList());
    }

    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min, boolean hasMax, double max, List<Double> boundaries, List<Long> counts, List<DoubleExemplarData> exemplars) {
        if (counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException("invalid counts: size should be " + (boundaries.size() + 1) + " instead of " + counts.size());
        }
        if (!ImmutableHistogramPointData.isStrictlyIncreasing(boundaries)) {
            throw new IllegalArgumentException("invalid boundaries: " + boundaries);
        }
        if (!boundaries.isEmpty() && (boundaries.get(0).isInfinite() || boundaries.get(boundaries.size() - 1).isInfinite())) {
            throw new IllegalArgumentException("invalid boundaries: contains explicit +/-Inf");
        }
        long totalCount = 0L;
        for (long c : PrimitiveLongList.toArray(counts)) {
            totalCount += c;
        }
        return new AutoValue_ImmutableHistogramPointData(startEpochNanos, epochNanos, attributes, sum, totalCount, hasMin, min, hasMax, max, Collections.unmodifiableList(new ArrayList<Double>(boundaries)), Collections.unmodifiableList(new ArrayList<Long>(counts)), exemplars);
    }

    ImmutableHistogramPointData() {
    }

    private static boolean isStrictlyIncreasing(List<Double> xs) {
        for (int i = 0; i < xs.size() - 1; ++i) {
            if (xs.get(i).compareTo(xs.get(i + 1)) < 0) continue;
            return false;
        }
        return true;
    }
}

