/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.LongExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.LongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.Aggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableGaugeData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableLongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableMetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.state.Measurement;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class LongLastValueAggregator
implements Aggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;

    public LongLastValueAggregator(Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongPointData diff(LongPointData previous, LongPointData current) {
        return current;
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            Long value = reset ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

